Imports System
Imports System.Collections

'
' Egzemplarze tej klasy odpowiadaj za zarzdzanie egzemplarzami
' klasy DocChar.
'
Friend Class DocCharFactory
    Private myChar As New MutableDocChar()
    Private docCharPool As New Hashtable()

    '
    ' Zwraca obiekt klasy DocChar, ktry reprezentuje dany na wejciu znak.
    ' c  - Reprezentowany reprezentowany znak.
    '
    Function GetDocChar(ByVal c As Char) As DocChar
        myChar.TheChar = c
        Dim thisChar As DocChar = DirectCast(docCharPool(myChar), DocChar)

        If thisChar Is Nothing Then
            thisChar = New DocChar(c)
            docCharPool(thisChar) = thisChar
        End If
        Return thisChar
    End Function 'GetDocChar

    '
    ' Aby odnajdywanie obiektw klasy DocChar w kolekcji typu Hashtable lub innej,
    ' podobnej kolekcji byo moliwe, bdziemy potrzebowali po jednym egzemplarzu
    ' DocChar dla kadego reprezentowanego znaku  wanie te obiekty klasy DocChar
    ' tworz nasz kolekcj. Tworzenie obiektw klasy DocChar dla kadej operacji
    ' wyszukiwania byoby zaprzeczeniem idei skadowania tych obiektw we wspomnianej
    ' kolekcji. Naszym celem jest uniknicie koniecznoci tworzenia odrbnego obiektu
    ' klasy DocChar dla kadego reprezentowanego znaku przez stosowanie pojedynczych
    ' egzemplarzy tej klasy do reprezentowania wszystkich wystpie tych samych znakw
    ' w dokumencie.
    '
    ' Alternatyw dla tworzenia osobnych obiektw klasy DocChar dla kadej operacji
    ' wyszukiwania jest wielokrotne stosowanie tego samego egzemplarza klasy DocChar
    ' i zmiana reprezentowanego znaku na potrzeby kolejnych operacji wyszukiwania.
    ' Najwikszym problemem zwizanym z tym rozwizaniem jest niezmienno obiektw
    ' klasy DocChar. Nie mamy moliwoci modyfikowania znaku reprezentowanego przez
    ' obiekt klasy DocChar.
    '
    ' Jednym ze sposobw obejcia tego problemu jest uycie prywatnej
    ' podklasy klasy DocChar, ktra bdzie implementowaa mechanizm
    ' niezbdny do modyfikowania reprezentowanych znakw.
    '
    Private Class MutableDocChar
        Inherits DocChar
        Private character As Char

        '
        ' Konstruktor
        '
        Public Sub New()
            MyBase.New(Convert.ToChar(0)) ' Znak przekazany na wejciu konstruktora klasy bazowej nie ma znaczenia.
        End Sub

        '
        ' Znak reprezentowany przez ten obiekt.
        '
        Public Shadows Property TheChar() As Char
            Get
                Return character
            End Get
            Set(ByVal value As Char)
                character = value
            End Set
        End Property
    End Class 'MutableDocChar

End Class 'DocCharFactory
